IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_LISTA_EST_PROD]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_PROD_LISTA_EST_PROD](
	[CD_CTR] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
 CONSTRAINT [PK_EST_PROD_LISTA_EST_PROD] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC,
	[CD_EMP] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_LISTA_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_LISTA_EST_PROD_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[EST_PROD_LISTA_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_LISTA_EST_PROD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_LISTA_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_LISTA_EST_PROD_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_LISTA_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_LISTA_EST_PROD_EST_PROD_LISTA] FOREIGN KEY([CD_CTR])
REFERENCES [dbo].[EST_PROD_LISTA] ([CD_CTR])

ALTER TABLE [dbo].[EST_PROD_LISTA_EST_PROD] CHECK CONSTRAINT [FK_EST_PROD_LISTA_EST_PROD_EST_PROD_LISTA]
end

